﻿<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Podsumowanie dokumentów</title>

    <script runat="server"> 

        public class Total : IComparable {
            readonly DefDokHandlowego definicja;
            decimal netto = 0;
            decimal vat = 0;
            decimal brutto = 0;
            decimal wartoscZakupu = 0;
            int liczba = 0;

            public Total(DefDokHandlowego definicja) {
                this.definicja = definicja;
            }
            public void Add(DokumentHandlowy dok) {
                netto += dok.Suma.Netto;
                vat += dok.Suma.VAT;
                brutto += dok.Suma.Brutto;
                wartoscZakupu += dok.Bufor || dok.Anulowany ? dok.WartośćWCenieZakupuBufor : dok.WartośćWCenieZakupu;
                ++liczba;
            }
            public DefDokHandlowego Definicja {
                get { return definicja; }
            }
            public int Liczba {
                get { return liczba; }
            }
            public decimal Netto {
                get { return netto; }
            }
            public decimal Brutto {
                get { return brutto; }
            }
            public decimal VAT {
                get { return vat; }
            }
            public decimal WartoscZakupu {
                get { return wartoscZakupu; }
            }
            public int CompareTo(object obj) {
                Total t = (Total)obj;
                return Definicja.Nazwa.CompareTo(t.Definicja.Nazwa);
            }
        }

        public class TotalPom : IComparable {
            readonly string sumbol;

            public TotalPom(string symbol) {
                this.sumbol = symbol;
            }
            public string Symbol {
                get { return sumbol; }
            }
            public int CompareTo(object obj) {
                TotalPom t = (TotalPom)obj;
                return Symbol.CompareTo(t.Symbol);
            }
        }

        void OnContextLoad(Object sender, EventArgs args) {

            Total tot = new Total(null);
            Row[] rows = (Row[])dc[typeof(Row[])];
            Hashtable result = new Hashtable();
            Hashtable resultKMBrak = new Hashtable();
            int licznik = 0, licznik1 = 0, licznik2 = 0, licznik3 = 0, anulowaneLicznik = 0;
            foreach (DokumentHandlowy dokument in rows) {
                if (++licznik % 30 == 0)
                    System.Diagnostics.Trace.Write(licznik * 100 / rows.Length, "Progress");

                if(dokument.Anulowany)
                    anulowaneLicznik++;


                if (dokument.KierunekMagazynu == Soneta.Magazyny.KierunekPartii.Brak) {
                    ++licznik3;
                    TotalPom tp = (TotalPom)resultKMBrak[dokument.Definicja];
                    if (tp == null)
                        resultKMBrak.Add(dokument.Definicja, new TotalPom(dokument.Definicja.Symbol));
                    continue;
                }

                if (dokument.Definicja.DuplikatWartosci)
                    ++licznik2;
                else {
                    ++licznik1;
                    tot.Add(dokument);
                }

                Total t = (Total)result[dokument.Definicja];
                if (t == null) {
                    t = new Total(dokument.Definicja);
                    result.Add(dokument.Definicja, t);
                }
                t.Add(dokument);
            }

            LiczbaLabel.EditValue = licznik1;
            DuplikatyLabel.EditValue = licznik2;
            AnulowaneLabel.EditValue = anulowaneLicznik;
            NettoLabel.EditValue = tot.Netto;
            VATLabel.EditValue = tot.VAT;
            BruttoLabel.EditValue = tot.Brutto;
            WartoscZakupuLabel.EditValue = tot.WartoscZakupu;
            ArrayList listaPom = new ArrayList(resultKMBrak.Values);
            listaPom.Sort();
            PominieteGrid.DataSource = listaPom;

            ArrayList lista = new ArrayList(result.Values);
            lista.Sort();
            Grid.DataSource = lista;
        }

    </script>

    <meta content="C#" name="CODE_LANGUAGE">
    <meta content="JavaScript" name="vs_defaultClientScript">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
</head>
<body>
    <form id="Form1" method="post" runat="server">
        <ea:DataContext ID="dc" runat="server" OnContextLoad="OnContextLoad"></ea:DataContext>
        <eb:ReportHeader ID="ReportHeader" Title="Podsumowanie dokumentów|</STRONG>Definicja:<STRONG> {1}|</STRONG>Okres:<STRONG> {2}|</STRONG>Magazyn:<STRONG> {3}|</STRONG>Nabywca:<STRONG> {4}</STRONG>"
            runat="server" DataMember4="DokHandloweViewInfo+WParams.Kontrahent" DataMember3="DokHandloweViewInfo+WParams.Magazyn"
            DataMember1="DokHandloweViewInfo+WParams.Definicja" DataMember2="DokHandloweViewInfo+WParams.Okres">
        </eb:ReportHeader>
        <ea:Grid ID="Grid" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel">
            <Columns>
                <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP.">
                </ea:GridColumn>
                <ea:GridColumn DataMember="Definicja" Caption="Definicja dokumentu">
                </ea:GridColumn>
                <ea:GridColumn Width="15" Align="Right" DataMember="Netto" Format="{0:n}">
                </ea:GridColumn>
                <ea:GridColumn Width="15" Align="Right" DataMember="VAT" Format="{0:n}">
                </ea:GridColumn>
                <ea:GridColumn Width="15" Align="Right" DataMember="Brutto" Format="{0:n}">
                </ea:GridColumn>
                <ea:GridColumn Width="15" Align="Right" DataMember="WartoscZakupu" Caption="Wartość zakupu"
                    Format="{0:n}">
                </ea:GridColumn>
                <ea:GridColumn Width="8" Align="Right" DataMember="Liczba">
                </ea:GridColumn>
            </Columns>
        </ea:Grid>
        <table id="Table1" style="font-size: 13px; width: 518px; font-family: Verdana;
            height: 117px" cellspacing="2" cellpadding="1" width="518" border="0">
            <tr>
                <td style="width: 246px">
                    W sumowaniu pominięto definicje:</td>
                <td>
                    <p align="right">
                        <ea:Grid ID="PominieteGrid" runat="server">
                            <Columns>
                                <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." runat="server">
                                </ea:GridColumn>
                                <ea:GridColumn DataMember="Symbol" Caption="" runat="server" Align="Right">
                                </ea:GridColumn>
                            </Columns>
                        </ea:Grid>
                    </p>
                </td>
            </tr>            
            <tr>
                <td style="width: 246px">
                    Ilość dokumentów:               <td>
                    <p align="right">
                        <ea:DataLabel ID="LiczbaLabel" runat="server" EncodeHTML="True">
                        </ea:DataLabel>
                        &nbsp;dokumentów</p>
                </td>
            </tr>
            <tr>
                <td style="width: 246px">
                    Ilość dokumentów duplikatów:</td>
                <td>
                    <p align="right">
                        <ea:DataLabel ID="DuplikatyLabel" runat="server" EncodeHTML="True">
                        </ea:DataLabel>
                        &nbsp;dokumentów</p>
                </td>
            </tr>
            <tr>
                <td style="width: 246px">
                    Ilość dokumentów anulowanych:</td>
                <td>
                    <p align="right">
                        <ea:DataLabel ID="AnulowaneLabel" runat="server" EncodeHTML="True">
                        </ea:DataLabel>
                        &nbsp;dokumentów</p>
                </td>
            </tr>
            <tr>
                <td style="width: 246px">
                    Wartość netto:</td>
                <td>
                    <p align="right">
                        <ea:DataLabel ID="NettoLabel" runat="server" Format="{0:n}" EncodeHTML="True">
                        </ea:DataLabel>
                        &nbsp;PLN</p>
                </td>
            </tr>
            <tr>
                <td style="width: 246px">
                    Wartość VAT:</td>
                <td>
                    <p align="right">
                        <ea:DataLabel ID="VATLabel" runat="server" Format="{0:n}" EncodeHTML="True">
                        </ea:DataLabel>
                        &nbsp;PLN</p>
                </td>
            </tr>
            <tr>
                <td style="width: 246px">
                    Wartość brutto:</td>
                <td>
                    <p align="right">
                        <ea:DataLabel ID="BruttoLabel" runat="server" Format="{0:n}" EncodeHTML="True">
                        </ea:DataLabel>
                        &nbsp;PLN</p>
                </td>
            </tr>
            <tr>
                <td style="width: 246px">
                    Wartość zakupu:</td>
                <td>
                    <p align="right">
                        <ea:DataLabel ID="WartoscZakupuLabel" runat="server" Format="{0:n}" EncodeHTML="True">
                        </ea:DataLabel>
                        &nbsp;PLN</p>
                </td>
            </tr>
        </table>
        <eb:ReportFooter ID="ReportFooter" runat="server" TheEnd="False">
        </eb:ReportFooter>
    </form>
</body>
</html>

